/**
 *
 */

#ifndef __meeting_service_impl_h__
#define __meeting_service_impl_h__

#include "csfunified/framework/UnifiedFactory.h"
#include "csfunified/services/impl/base/MeetingServiceBaseImpl.h"
#include "csfunified/featuresets/MeetingFeatureSet.h"
#include "csf/logger/CSFLogger.h"

namespace CSFUnified {

    class JMLoggerImpl;

    class CSFUNIFIED_API MeetingServiceImpl : public MeetingServiceBaseImpl
    {
    public:
        MeetingServiceImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory);
        MeetingServiceImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory, bool offServicesDispatcher);
        virtual ~MeetingServiceImpl();
        
    public:
		virtual bool isMeetingModuleEnabled();
		virtual bool isDesktopShareModuleEnable();
		virtual CSFUnified::MailServiceTypeEnum::MailServiceType getDefaultMailClient();

        virtual SMART_PTR_NS::shared_ptr<CSFUnified::MeetingMgrController> getMeetingMgrController();
        virtual SMART_PTR_NS::shared_ptr<CSFUnified::DesktopSharingController> getDesktopSharingController();
        virtual SMART_PTR_NS::shared_ptr<CSFUnified::MeetingAccountController> getMeetingAccountController();
        virtual SMART_PTR_NS::shared_ptr<CSFUnified::CMRController> getCMRController(std::string JID);
        virtual void registerCMRMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::CMRMeetingCallback> callback);
        virtual void unregisterCMRMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::CMRMeetingCallback> callback);

		virtual void loggedIn();

		virtual void loggedOut();

	private:
		SMART_PTR_NS::shared_ptr<JMLoggerImpl> m_MeetingLogger;
    };

};


#endif	// __meeting_service_impl_h__